# Search in Strings {#search-in-strings}

There are 3 ways to search in strings:

\(1\) To search whether a string contains another string, use functions [like](../../../Functions/l/like.md) and [ilike](../../../Functions/i/ilike.md) . `like` is case sensitive and `ilike` is case insensitive.

```
a=`IBM`ibm`MSFT`Goog`YHOO`ORCL;
a ilike "%OO%";
// output: [0,0,0,1,1,0]

a like "%oo%"
// output: [0,0,0,1,0,0]
```

\(2\) To find the location of the first occurrence of a string in another string, use function [strpos](../../../Functions/s/strpos.md) .

```
strpos("abcdefg","cd");
// output: 2

strpos("abcdefg","d");
// output: 3

strpos("abcdefg","ah");
// output: -1
```

\(3\) To find the location of the first occurrence of a string or a regular expression pattern, use function [regexFind](../../../Functions/r/regexFind.md). Compared with function [strpos](../../../Functions/s/strpos.md), in `regexFind` we can search a regular expression pattern, and we can also specify the starting position to search. To search a string in another string without specifying the starting position to search, we should use `strpos` instead of `regexFind` as the former is faster.

```
regexFind("FB IBM FB IBM AMZN", `IBM, 7);
// output: 10

regexFind("this subject has a submarine as subsequence", "\\b(sub)([^ ]*)");
// output: 5

regexFind("this subject has a submarine as subsequence", "\\b(sub)([^ ]*)", 10);
// output: 19
```

**Parent topic:**[String Objects](../../../Programming/DataManipulation/StringObjects/StringObjects.md)

