# Null Value Operations {#null-value-operations}

Generally, if a null value is one of the arguments of a function/operator, the result would be null.

``` {#codeblock_awx_jpb_ndc}
x = 1.0 + 5.6 * 3 + NULL + 3
isNull(x)
// output: 1

typestr x;
// output: DOUBLE
```

However, there are special cases as follows:

-   With comparison operators &gt;, &gt;=, &lt;, &lt;=, and between, null values represent the minimum value when the configuration parameter *nullAsMinValueForComparison* is set to true \(default\). When it is set to false, the comparison result is null.

    ``` {#codeblock_tfn_dqb_ndc}
    // nullAsMinValueForComparison = true
    1 < NULL // output: false
    1 > NULL // output: true
    
    // nullAsMinValueForComparison = false
    1 < NULL // output: 00b
    1 > NULL // output: 00b
    ```

-   With comparison operators !=, &lt;&gt;, and ==, null values represent the minimum value and two null values are considered equal.

    ``` {#codeblock_f3w_fds_5dc}
    NULL == NULL // output: true
    NULL != NULL // output: false
    ```

-   In the `or` function, if only one operand is null, the result is equal to the other non-null operand when the configuration parameter *logicOrIgnoreNull* is set to true \(default\). When it is set to false, the result is null is one operand is null.

    ``` {#codeblock_bs2_wvb_ndc}
    // logicOrIgnoreNull = true
    NULL or true // output: true
    NULL or false // output: false
    NULL or NULL // output: 00b
    
    // logicOrIgnoreNull = false
    
    NULL or true // output: 00b
    NULL or false // output: 00b
    NULL or NULL // output: 00b
    ```

-   In aggregate functions such as `sum`/`avg`/`med`, null values are ignored.

    ``` {#codeblock_udg_zvb_ndc}
    x = 1 2 NULL NULL 3;
    sum(x)
    // output: 6
    
    avg(x)
    // output: 2
    
    ```

-   When sorting elements in a vector, null values represent the minimum value.
-   In functions `ols`/`olsEx`/`corrMatrix`/`olsEx`, null values in parameters are replaced with 0.

-   **[Functions on Null Values](../../../../Programming/DataManipulation/NullValueManipulation/NullValueOperation/FunctionsonNULLs.md)**  

-   **[Scalar Null Values](../../../../Programming/DataManipulation/NullValueManipulation/NullValueOperation/ScalarNULLs.md)**  

-   **[Table with Null Values](../../../../Programming/DataManipulation/NullValueManipulation/NullValueOperation/TablewithNULLs.md)**  

-   **[Vector/Set/Tuple with Null Values](../../../../Programming/DataManipulation/NullValueManipulation/NullValueOperation/VectorSetTuplewithNULLs.md)**  


**Parent topic:**[Null Value Manipulation](../../../../Programming/DataManipulation/NullValueManipulation/NullValueManipulation.md)

