# Null Value Manipulation {#null-value-manipulation}

Null values are common in data analysis. In DolphinDB, null values are specially designed for optimal performance. In this chapter, we will explain how null values are expressed, initialized, and operated. We will also discuss the behavior of null values with normal vector functions, aggregate functions, and higher order template functions.

Null values in DolphinDB fall into 2 categories, VOID type and other data types \(e.g., int\(\), double\(\), string\(NULL\)\). You get a null value of VOID type usually when using a function without return value in an assignment statement or expression. You can use the [isVoid](../../../Functions/i/isVoid.md) function to check if a null value is VOID type. Use [isNull](../../../Functions/i/isNull.md) or [isValid](../../../Functions/i/isValid.md) to check the existence of null values of any type. If you are not concerned with the data type of a null value, it is recommended to use [isNull](../../../Functions/i/isNull.md) or [isValid](../../../Functions/i/isValid.md).

Starting from version 1.30.22, null in lowercase is supported.

Starting from version 2.00.10, null in lowercase is supported.

```
typestr(NULL);
//output: VOID

isNull(null)
//output: true

def f(){
 1+2
}
typestr(f())
//output: VOID

typestr(int());
//output: INT

isVoid(NULL)
//output: true

isVoid(int())
//output: false

isNull(NULL)
//output: true

isNull(00i)
//output: true
```

When a calculation involves null values of VOID type and null values of a different type, the VOID type null values will be converted to the other type.

```
int()==NULL
// output: true
in(1 00f NULL 1.3, 00f) == [false, true, true, false]
// output: [true,true,true,true]
```

