# zigzag {#zigzag}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`zigzag(HL, [change=10], [percent=true], [retrace=false], [lastExtreme=true])`

## Details {#details}

**HL** is a numeric vector or a numeric matrix with two columns.

**change** \(optional\) is the minimum threshold for extreme value movement.

**percent** \(optional\) is a Boolean value indicating whether *change* is used as a percentage.

**retrace** \(optional\) is a Boolean value. The default value is false.

-   true: *change* represents a retracement of the previous move.

-   false: *change* represents the change between the extreme points.


Note: If *percent*=false, *retrace* can only take "false". Setting it to true has no effect.

**lastExtreme** \(optional\) is a Boolean value indicating whether to output the last point if multiple consecutive points have the same value. The default value is true.

## Details {#details-1}

`zigzag` is mainly used to filter values with smaller movements in *HL*. Only extreme points that satisfy the conditions will be output.

If *HL* is a vector, return a vector with the same length as *HL*; if *HL* is a matrix, return a vector with the same number of rows as *HL*.

## Examples {#examples}

```
t = table(1.1 2.3 4.45 3.67 4.9 as `low, 1.3 2.8 4.9 3.73 6.28 as `high)
HL = matrix(t[`low], t[`high])
zz = zigzag(HL, change=10, percent=true, retrace=false, lastExtreme=true)
```

|0|1|2|3|4|
|---|---|---|---|---|
|1.2||4.45|3.73|4.9|

```
HL = 1.2 3 3.1 14 14.5 14.7 25.0 17.8 19 10
zz = zigzag(HL, change=10, percent=true, retrace=false, lastExtreme=true)
```

|0|1|2|3|4|5|6|7|8|9|
|---|---|---|---|---|---|---|---|---|---|
|1.2||||||25|||10|

