# xdb {#xdb}

## Syntax {#syntax}

`xdb(siteAlias, [userId], [password], [enableSSL=false])`

or

`xdb(host, port, [userId], [password], [enableSSL=false])`

## Arguments {#arguments}

**siteAlias** is the alias of the remote node. It needs to be defined in configuration.

**host** is the host name \(IP address or website\) of the remote node.

**port** is an integral indicating the port number of the remote node.

**userId** and **password** \(optional\) are based on the user's profile. They are used if the administrator has enabled [UserAccessControl](../../Maintenance/UserAccessControl.md).

**enableSSL** \(optional\) is a boolean value determining whether to use the SSL protocol for encrypted communication. The default value is false.

## Details {#details}

Connect to a remote site. This remote site must be on. If the connection is successful, it returns the handle of the remote connection.

Since DolphinDB 2.00.10.10, users can determine whether to limit the number of failed login attempts by setting the configuration *enhancedSecurityVerification*. If it is not specified, no limit will be applied; if it is set to true, a user's account will be blocked for 10 minutes if the password is entered wrongly 5 times in a minute.

## Examples {#examples}

```
h2=xdb("local8081");
h2;
// output: "Conn[localhost:8081:1166953221]"

h21=xdb("localhost",8081);
h21;
// output: "Conn[localhost:8081:1441295757]"

h4=xdb("local8083","userAdm","passAdm");
h4;
// output: "Conn[localhost:8083:1166953221]"

h41=xdb("localhost",8083, "user001","pass001");
h41;
// output: "Conn[localhost:8083:597793698]"
```

