# writeRecord {#writerecord}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`writeRecord(handle, object, [offset=0], [length])`

## Arguments {#arguments}

**handle** is a binary file handle.

**object** is a table or a tuple with array elements of equal sizes.

**offset** \(optional\) specifies the starting row position.

**length** \(optional\) indicates the number of rows to be written.

## Details {#details}

Convert DolphinDB objects such as tables or tuples to binary files. The function returns with the number of rows written to *handle*.

## Examples {#examples}

```
t=table(1..10000 as id, 1..10000+100 as value);

f1=file("C:/DolphinDB/a.bin", "w");
f1.writeRecord(t);
// output: 10000

f2=file("C:/DolphinDB/b.bin", "w");
f2.writeRecord(t, 100, 1000);
// output: 1000

f3=file("C:/DolphinDB/c.bin", "w");
f3.writeRecord(t, 100, 10000);
// output: The optional argument length is invalid.
```

