# writeLogLevel {#writeloglevel}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`writeLogLevel(level, X1, [X2, X3,...,Xn])`

## Arguments {#arguments}

**level** indicates the log level. It accepts these values in ascending order of importance: DEBUG \(0\), INFO \(1\), WARNING \(2\), and ERROR \(3\).

**X1**, **X2**, **X3**, ... **Xn** is the content to be written to the log file. Each *Xi* is a line in the log file. The following data types are supported: Logical, Integral, Temporal, Floating, Literal, and Decimal.

## Details {#details}

The command writes logs of the specified level to the log files. It can only be called by an administrator.

**Note:** The specified *level* must be equal to or higher than the log level configured by the *logLevel* parameter or set by the `setLogLevel` function, otherwise the logs will not be written to the log file.

## Examples {#examples}

```
writeLogLevel(INFO,111111111111,"This is an INFO message") 
// Check the log file.
<INFO> :111111111111
<INFO> :This is an INFO message
```

Related functions: [writeLog](writeLog.md), [setLogLevel](../s/setLogLevel.md)

