# writeBytes {#writebytes}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`writeBytes(handle, bytes)`

## Details {#details}

Write the entire buffer to the file. The buffer must be a char scalar or char vector. If the operation succeeds, it returns the actual number of bytes written; otherwise, an IOException will be raised.

## Examples {#examples}

```
// define a file copy function
def fileCopy(source, target){
   s = file(source)
   len = s.seek(0,TAIL)
   s.seek(0,HEAD)
   t = file(target,"w")
   if(len==0) return
   do{
       buf = s.readBytes(min(len,1024))
       t.writeBytes(buf)
       len -= buf.size()
   }while(len)
};

fileCopy("test.txt","testcopy.txt");
```

