# wilder {#wilder}

## Syntax {#syntax}

`wilder(X, window)`

Please see [TALib](../Themes/TALib.md) for the parameters and windowing logic.

## Details {#details}

Calculate the Exponential Moving Average \(ema\) for *X* in a sliding window of the given length.

Different from [ema](../e/ema.md), the function `wilder` uses Welles Wilder's Moving Average Formula, which is:

![](../../images/wilderxk.png)

where ![](../../images/wilderxk_name.png) is the k-th exponential moving average, n is the length of sliding window, and X\_k is the k-th element of the vector X.

## Examples {#examples}

```
x=12.1 12.2 12.6 12.8 11.9 11.6 11.2
wilder(x,3);
// output: [,,12.299999999999998,12.466666666666668,12.27777777777778,12.051851851851854,11.767901234567903]

x=matrix(12.1 12.2 12.6 12.8 11.9 11.6 11.2, 14 15 18 19 21 12 10)
wilder(x,3);
```

|col1|col2|
|----|----|
|||
|||
|12.3|15.6667|
|12.4667|16.7778|
|12.2778|18.1852|
|12.0519|16.1235|
|11.7679|14.0823|

Related functions: [ema](../e/ema.md), [gema](../g/gema.md), [tema](../t/tema.md)

