# warmupOrcaStreamEngine {#warmupOrcaStreamEngine}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`warmupOrcaStreamEngine(name, data)`

## Arguments {#arguments}

**name** is a string representing the name of the streaming egine. You can provide either the fully qualified name \(FQN\), such as "catalog\_name.orca\_engine.engine\_name", or just the engine name, like "engine\_name". If only the name is given, the system will automatically complete it using the current catalog.

**data** is a table object containing the data to be used for warm-up.

## Details {#details}

Ingest data into a stream engine without outputting results. When the next batch of data is ingested, the calculation can be sped up with the results that have already been generated.

Currently it only supports the reactive state engine, and \(daily\) time series engine.

Unlike `[warmupStreamEngine](warmupStreamEngine.md)`, `warmupOrcaStreamEngine` can be called from any node in the cluster. Under the hood, it performs a remote call to execute `warmupStreamEngine` on the node where the engine resides.

## Examples {#examples}

In the example below, `warmupOrcaStreamEngine("rse", t)` writes the data table `t` into the reactive state engine `rse` for warm-up, ensuring that the `<ema(value, 100)>` metric has sufficient historical data within the window during the warm-up phase.

``` {#codeblock_zq1_tms_c2c}
if (!existsCatalog("test")) {
	createCatalog("test")
}
go;
use catalog test

t = table(1..100 as id, 1..100 as value, take(09:29:00.000..13:00:00.000, 100) as timestamp)
g = createStreamGraph("factor")
baseStream = g.source("snapshot",  1024:0, schema(t).colDefs.name, schema(t).colDefs.typeString)
  .reactiveStateEngine([<ema(value, 100)>, <timestamp>])
  .setEngineName("rse")
  .buffer("end")
  
g.submit()

warmupOrcaStreamEngine("rse", t)
appendOrcaStreamTable("snapshot", t)
```

