# vectorNorm {#vectorNorm}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`vectorNorm(x, [ord], [axis], [keepDims])`

## Arguments {#topic_ud4_s1w_fcc}

**x** is a vector or matrix of any numeric type except DECIMAL. It cannot be empty.

**ord**\(optional\) is an INT, STRING or floating-point scalar indicating the order of norm. Note:

-   When *ord* is a string, it must be: 'inf', '-inf', 'nuc', or 'fro'.
-   When *ord* is less than 1, the result is technically not a mathematical "norm", but it may still be useful for various numerical purposes.

The following describes the method for computing the norm based on different *x* and *ord*:

|*ord*|norm for vectors|norm for matrices|
|:----|:---------------|:----------------|
|None|2-norm|Frobenius norm|
|0|sum\(x != 0\)|-|
|-1|sum\(abs\(x\)^ord\)^\(1/ord\)|min\(sum\(abs\(x\), axis=0\)\)|
|1|sum\(abs\(x\)^ord\)^\(1/ord\)|max\(sum\(abs\(x\), axis=0\)\)|
|-2|sum\(abs\(x\)^ord\)^\(1/ord\)|2-norm \(largest sing. value\)|
|2|sum\(abs\(x\)^ord\)^\(1/ord\)|smallest singular value|
|inf|max\(abs\(x\)\)|max\(sum\(abs\(x\), axis=1\)\)|
|-inf|min\(abs\(x\)\)|min\(sum\(abs\(x\), axis=1\)\)|
|nuc|-|nuclear norm|
|fro|-|Frobenius norm|
|other|sum\(abs\(x\)^ord\)^\(1/ord\)|-|

**axis** \(optional\) is an integer vector or scalar indicating the direction along which to compute the norm. It cannot contain empty elements.

-   When *x* is a vector, *axis* can only be 0.
-   When *x* is a matrix, *axis*:
    -   Has a length of no more than 2.
    -   Cannot contain duplicate elements.
    -   Has elements with values of 0 or 1.

**keepDims** \(optional\): A boolean scalar indicating whether the returned result should maintain the same form as *x*. The default is false.

## Details {#topic_e2g_1bw_fcc}

The function computes a matrix or vector norm. Note that it’s not recommended to use `vectorNorm` in SQL statements.

**Return Value**: An INT, LONG, or DOUBLE scalar, vector, or matrix.

## Examples {#topic_drd_bbw_fcc}

When *x* is a vector, compute norms:

``` {#codeblock_pl1_gbw_fcc}
x = 1..4

vectorNorm(x) // Output: 5.477225575051661

vectorNorm(x, keepDims=true) // Output: 5.477225575051661

vectorNorm(x, ord=1) // Output: 10
vectorNorm(x, ord=1, axis=0) // Output: 10 

vectorNorm(x, ord=-1) // Output 0.4800000000000001
vectorNorm(x, ord=-1, axis=0) // Output double: 10

vectorNorm(x, ord="inf", axis=0) //Output: 4 
vectorNorm(x, ord="-inf", axis=0) //Output: 1

vectorNorm(x, ord=3) // Output: 4.641588833612778
vectorNorm(x, ord=-20.689) // Output: 0.9999999714010688

vectorNorm(x, ord="fro") // throw exception
vectorNorm(x, ord="nuc") // throw exception
```

When *x* is a matrix, compute norms:

``` {#codeblock_rl1_gbw_fcc}
x = 1..4$2:2

vectorNorm(x) // Output: 5.477225575051661
vectorNorm(x, keepDims=true) // Output: 5.477225575051661

vectorNorm(x, ord=1) // Output: 7
vectorNorm(x, ord=1, axis=0) // Output: 3 7 
vectorNorm(x, ord=1, axis=1) // Output: 4 6

vectorNorm(x, ord=-1, axis=0) // Output: 0.6666666666666666 1.7142857142857144
vectorNorm(x, ord=-1, axis=1) // Output: 0.75 1.3333333333333333

vectorNorm(x, ord=1, axis=(0 1)) // Output: 7
vectorNorm(x, ord=1, axis=(1 0)) // Output: 6 

vectorNorm(x, ord=-1, axis=(0 1)) // Output: 3
vectorNorm(x, ord=-1, axis=(1 0)) // Output: 4 

vectorNorm(x, ord="inf", axis=(0 1)) // Output: 4 
vectorNorm(x, ord="inf", axis=(1 0)) // Output: 3 

vectorNorm(x, ord="-inf", axis=(0 1)) // Output: 6 
vectorNorm(x, ord="-inf", axis=(1 0)) // Output: 7 

vectorNorm(x, ord="fro", axis=(1 0)) // Output: 5.477225575051661
vectorNorm(x, ord="fro", axis=(0 1)) // Output: 5.477225575051661

vectorNorm(x, ord=-2, axis=(1 0)) // Output: 0.3659661906262574
vectorNorm(x, ord=-2, axis=(0 1)) // Output: 0.3659661906262574

vectorNorm(x, ord=2, axis=(1 0)) // Output: 5.464985704219043
vectorNorm(x, ord=2, axis=(0 1)) // Output: 5.464985704219043

vectorNorm(x, ord="nuc", axis=(1 0)) // Output: 5.8309518948453
vectorNorm(x, ord="nuc", axis=(0 1)) // Output: 5.8309518948453

vectorNorm(x, ord=3) // throw exception
```

