# vectorAR {#vectorar}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`vectorAR(ds, endogColNames, [exog], [trend='c'], [maxLag], [ic])`

## Arguments {#details}

**ds** is an in-memory table or a vector consisting of DataSource objects, containing the multivariate time series to be analyzed. *ds* cannot be empty.

**endogColNames** is a STRING vector indicating the column names of the endogenous variables in *ds*. The matrix formed by *endogColNames* extracted from *ds*is the multivariate time series to be analyzed.

**exog** \(optional\) is a numeric matrix representing exogenous variables except the endogenous time series. Each column of the matrix represents the time series data of an exogenous variable, and the number of rows must equal the number of rows in *ds*.

**trend** \(optional\) specifies constants and trend orders used in the regression. It can be

-   'c' \(default\) - add constant

-   'ct' - constant and treand

-   'ctt' - constant, linear, and quadratic trend

-   'n' - no constant or trend


**maxLag** \(optional\) is a non-negative integer representing the maximum number of lags to check for order selection. If not provided, the default value of is used, where *nobs*indicates the sample size.

**ic** \(optional\) is a STRING scalar indicating the information criterion to use for VAR order selection. The default value is null. It can be:

-   'aic': Akaike

-   'bic': Bayesian/Schwarz

-   'fpe': Final prediction error

-   'hqic': Hannan-Quinn


## Details {#arguments}

Analyze multivariate time series using the Vector Autoregression model \(VAR model\).

**Return Value:**A dictionary representing the analysis results of the VAR model with the following members:

-   params: A floating-point matrix representing the parameters obtained from fitting the VAR model.

-   kAr: An integer representing the order of the VAR process.

-   kTrend: An integer representing the number of trends in the VAR process.

-   nobs: An integer representing the number of observations in the VAR model analysis.

-   sigmaU: A floating-point matrix representing the estimated variance of the white noise process.

-   sigmaUMle: A floating-point matrix representing the biased maximum likelihood estimate of the noise process covariance.

-   aic: A floating-point scalar representing the Akaike Information Criterion.

-   bic: A floating-point scalar representing the Bayesian Information Criterion.

-   hqic: A floating-point scalar representing the Hannan-Quinn Information Criterion.

-   fpe: A floating-point scalar representing the Final Prediction Error Information Criterion.

-   llf: A floating-point scalar representing the log-likelihood value of the VAR model.


## Examples {#examples}

This example uses a file named macrodata.csv, taking the *realgdp*, *realcons*, and *realinv*columns as endogenous variables, and sets the *maxlag*to 2. The VAR model is then used to analyze the multivariate time series.

Output:

``` {#codeblock_h2x_2dj_zbc}
nobs->200
hqic->-27.789187688321
llf->1962.570824044325
kTrend->1
aic->-27.929339439671
fpe->0E-12
params->
#0              #1              #2             
0.001526972352  0.005459603048  -0.023902520885
-0.279434735873 -0.100467978082 -1.970973673795
0.675015751748  0.268639552522  4.414162326990 
0.033219450793  0.025738726522  0.225478953223 
0.008221084912  -0.123173927706 0.380785849237 
0.290457628129  0.232499435917  0.800280917529 
-0.007320907532 0.023503761040  -0.124079061576
sigmaU->
#0             #1             #2            
0.000057113648 0.000029839495 0.000224637467
0.000029839495 0.000042830532 0.000034191732
0.000224637467 0.000034191732 0.001567709895
sigmaUMle->
#0             #1             #2            
0.000055114670 0.000028795112 0.000216775156
0.000028795112 0.000041331464 0.000032995021
0.000216775156 0.000032995021 0.001512840049

kAr->2
bic->-27.583016116183
```

