# varp {#varp}

## Syntax {#syntax}

`varp(X)`

## Arguments {#arguments}

**X** is a vector/matrix.

## Details {#details}

If *X* is a vector, return the population variance of *X*.

If *X* is a matrix, ccalculate the population variance of each column and return a vector.

As with all other aggregate functions, null values are ignored in the calculation.

## Examples {#examples}

```
varp(1 1 1);
// output: 0

varp(1 2 3);
// output: 0.666667

m=matrix(1 3 5 7 9, 1 4 7 10 13);
m;
```

|\#0|\#1|
|---|---|
|1|1|
|3|4|
|5|7|
|7|10|
|9|13|

```python
varp(m);
// output: [8,18]
```

