# varma {#varma}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`varma(ds,endogColNames,order,[exog],[trend='c'],[errorCovType='unstructured'],[measurementError=false],[enforceStationarity=true],[enforceInvertibility=true],[trendOffset=1], [maxIter=50])`

## Details {#details}

`varma` analyzes multivariate time series using a Vector Autoregressive Moving-Average \(VARMA\) model. It returns a dictionary containing the analysis results.

**Return value:** A dictionary containing the following keys:

-   params: A floating matrix of estimated parameters for the VARMA model.
-   kAr: An integer representing the order of the vector autoregressive process.
-   kMa: An integer representing the order of the vector moving average part.
-   kTrend: An integer representing the number of trend terms in the VARMA model.
-   nobs: An integer representing the number of observations in the input multivariate time series.
-   aic: A floating-point number representing the Akaike Information Criterion.
-   bic: A floating-point number representing the Bayesian Information Criterion.
-   hqic: A floating-point number representing the Hannan-Quinn Information Criterion.
-   llf: A floating-point number representing the log-likelihood value of the VARMA model.

## Arguments {#arguments}

-   **ds** is an in-memory table or a DATASOURCE vector containing the multivariate time series to be analyzed. *ds* cannot be empty. Only if the first column of the data source is a time column, the model will automatically sort the data based on the column.
-   **endogColNames** is a STRING vector indicating the column names of the endogenous variables in *ds*.
-   **order** is a vector with two non-negative integers indicating the number of autoregressive \(AR\) and moving average \(MA\) parameters to use.
-   **exog** \(optional\) is a numeric matrix representing exogenous variables except the endogenous time series. Each column of the matrix represents the time series data of an exogenous variable, and the number of rows must equal the number of rows in *ds*.
-   **trend** \(optional\) is a string indicating the constant and trend order used in the regression. Possible values:
    -   "c" \(default\) - add constant
    -   "ct" - constant and treand
    -   "ctt" - constant, linear, and quadratic trend
    -   "n" - no constant or trend
-   **errorCovType** \(optional\) is a string scalar specifying the structure of the error term's covariance matrix. Possible values:
    -   'unstructured' \(default\): Preserve the lower triangular part of the covariance matrix
    -   'diagonal': Preserve only the diagonal part
-   **measurementError** \(optional\) is a boolean scalar indicating whether to assume the endogenous observations were measured with error. Default is false.
-   **enforceStationarity** \(optional\) is a boolean scalar indicating whether to transform AR parameters to enforce stationarity in the autoregressive component of the model. Default is true.
-   **enforceInvertibility** \(optional\) is a boolean scalar indicating whether to transform MA parameters to enforce invertibility in the moving average component of the model. Default is true.
-   **trendOffset** \(optional\) is a positive representing the offset at which time trend values start. Default is 1.
-   **maxIter** \(optional\) is a positive integer indicating the maximum number of iterations during fitting. Default is 50.

## Examples {#examples}

Analyze the multivariate time series in the *macrodata.csv* file:

``` {#codeblock_qxc_nfc_bdc}
data = loadText("macrodata.csv")
my_exog = matrix(DOUBLE, size(data), 1,,1)
result = varma(data, [`realgdp, `realcons, `realinv],[1,1],trend="c", exog=my_exog)
print(result)

/* Output:
params->[0.001792375138657,0.003160556421415,-0.007883363910928,-0.339419264165185,0.755250482937653,0.058642159539323,-0.133526968617148,0.32767138782651,0.042514529460363,-2.212343999390979,4.610354288385349,0.302449619489419,0.056726965953926,-0.069554043921028,-0.024169855056237,0.03072738358672,-0.056571376624308,-0.015977637956917,0.249792348549773,-0.171657812582861,-0.075503097693781,0.001792375138657,0.003160556421415,-0.007883363910928,0.007685902441147,0.003916408996852,0.005142039118261,0.030338334390003,-0.016066874864259,0.020322423082551]
llf->1974.199528289279214
kAr->1
kMa->1
kTrend->1
nobs->202
aic->-3888.399056578558429
bic->-3789.151025656522506
hqic->-3848.243123697545343
*/
```

