# useOrcaStreamTable {#useOrcaStreamTable}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`useOrcaStreamTable(name, func, args...)`

## Arguments {#arguments}

**name** is a string representing the name of the Orca stream table. You can provide either the fully qualified name \(FQN\), such as "trading.orca\_table.factors", or just the table name, like "factors". If only the name is given, the system will automatically complete it using the current catalog.

**func**is a function \(built-in or user-defined\) to be executed on the node where the stream table resides. This function must take at least one parameter; the system will automatically pass the stream table object as the first argument.

**args…** are additional arguments to be passed to *func*, similar to how arguments are passed in remote procedure calls \([rpc](../r/rpc.md)\).

## Details {#details}

This function locates the node where the specified orca stream table resides, retrieves the stream table object, and passes it as the first argument to the specified *func*for execution.

This mechanism allows users to remotely perform operations related to the stream table \(e.g., `replay`, `getStreamTableFilterColumn`, etc.\) from local machine without needing to manage the bindings between nodes and stream tables.

## Examples {#examples}

View the filter column of the stream table `demo.orca_table.transaction` using the built-in function `getStreamTableFilterColumn`:

``` {#codeblock_zq1_tms_c2c}
useOrcaStreamTable("demo.orca_table.transaction", getStreamTableFilterColumn)
```

