# updateMCPTool {#updateMCPTool}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`updateMCPTool(name, [func], [argNames], [argTypes], [description], [extraInfo])`

## Arguments {#arguments}

**name** is a STRING scalar indicating the tool name.

**func** \(optional\) is a user-defined function.

**argNames** \(optional\) is a STRING vector specifying the argument names. Pass `[]` if no parameters are required.

**argTypes** \(optional\) is a STRING vector specifying the data types of arguments, which can be DolphinDB data types or JSON data types. Supported types include:

|DolphinDB Type|JSON Type|
|--------------|---------|
|STRING|"string"|
|TEMPORAL|"string"|
|DOUBLE|"number"|
|BOOL|"boolean"|
|STRING\[\]|"array&lt;string&gt;"|
|TEMPORAL\[\]|"array&lt;string&gt;"|
|DOUBLE\[\]|"array&lt;number&gt;"|
|BOOL\[\]|"array&lt;boolean&gt;"|

**description** \(optional\) A STRING scalar describing the tool.

**extraInfo** \(optional\) A dictionary where keys are strings and values are of type ANY or STRING, used to specify additional metadata. Currently, the key "title" is supported.

## Details {#details}

Updates an MCP tool.

If a parameter is not specified, the corresponding field remains unchanged. An empty string is treated as unspecified. To clear the field, pass a single space instead.

**Return value**: A string representing the name of the updated tool.

## Examples {#examples}

``` {#codeblock_y55_32x_mgc}
// Define a tool
def myTool(x) {
   return x * 2 + 1
}

info = {
    "title": "DolphinDB Tools"
}

addMCPTool("myTool", myTool, ["a"], ["number"], "This is a tool", info)

// Update the tool 
def myNewTool(x, y) {
   return x * 2 + y
}

updateMCPTool("myTool", myNewTool, ["a","b"], ["number","number"], " ")

// Update only extra information
newInfo = {
    "title": "Updated Tools"
}

updateMCPTool(name="myTool", extraInfo=newInfo)
```

