# updateMCPPrompt {#updateMCPPrompt}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`updateMCPPrompt(name, [message], [description], [extraInfo])`

## Arguments {#arguments}

**name** is a STRING scalar indicating the name of the prompt template.

**message** is a STRING scalar indicating the content of the prompt template. It can contain the placeholder `{}`.

**description** \(optional\) is a STRING scalar indicating the description of the prompt template.

**extraInfo** \(optional\) is a dictionary with STRING keys and ANY or STRING values used to specify additional information. Currently support "title" only.

## Details {#details}

Updates an MCP prompt template.

If a parameter is not provided, the corresponding field is left unchanged. An empty string is ignored. Therefore, to clear the description, use a space instead of an empty string.

**Return value**: A string indicating the name of the updated MCP prompt template.

## Examples {#examples}

``` {#codeblock_y55_32x_mgc}
// define a prompt template
addMCPPrompt(
  name = "stock_summary",
  message = "Summary the trend of ${stock} from ${startDate} to ${endDate}.",
  description = "Generate a natural-language overview of a stock over a time period",
  extraInfo = {title : "Stock Trend Summary"}
)

// update a prompt template
updateMCPPrompt(
  name = "stock_summary",
  message = "Summary the performance of ${stock} during ${startDate} to ${endDate}.",
  description = "description after updating"
)
```

