# updateLicense {#updatelicense}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`updateLicense()`

## Arguments {#arguments}

None

## Details {#details}

Update the license without restarting the node.

After replacing the license file, executing this function can update the license without restarting the node. You can execute [getLicenseExpiration](../g/getLicenseExpiration.md) to check whether the license file has been updated.

The function only takes effect on the node where it is executed. For a cluster, it must be executed on all controllers, agents, and data nodes.

Note:

-   The license for update must satisfy the following conditions \(which can be checked with function [license](../l/license.md)\):

    -   The client name \(clientName\) and the authorization mode \(authorization\) of the license must be the same as the original license.

    -   The number of nodes \(maxNodes\), memory size \(maxMemoryPerNode\) and the number of CPU cores \(maxCoresPerNode\) authorized by the license cannot be smaller than the original ones.

-   Online update is not supported if the original authorization is site.

-   Since version 1.30.21/2.00.9, DolphinDB process can be bound to specific CPU cores. If the binding cores are changed in the license to be replaced, DolphinDB must be rebooted after the upgrade.

## Examples {#examples}

```
updateLicense()
/* output:
authorization->commercial
licenseType->0
maxMemoryPerNode->32
maxCoresPerNode->8
clientName->test license
bindCPU->true
expiration->2022.03.01
maxNodes->8
version->
modules->-1
*/
```

