# unsubscribeTable {#unsubscribetable}

## Syntax {#syntax}

`unsubscribeTable([server], tableName, [actionName], [removeOffset=true], [raftGroup])`

## Arguments {#arguments}

**server** \(optional\) is a string indicating the alias of a server or the xdb connection to a server where the stream table is located. If it is unspecified or an empty string \(""\), it means the local instance.

**tableName** is a string indicating the name of the shared stream table to be unsubscribed on the aforementioned server.

**actionName** \(optional\) is a string indicating the name assigned to the handler. It can have letters, digits and underscores. If actionName is specified when the subscription is initiated, it must be specified in unsubscribeTable as well.

**removeOffset** \(optional\) is a Boolean value indicating whether to delete the offset of the latest record that has been calculated. \(set *persistOffset* = true in [subscribeTable](../s/subscribeTable.md) to keep the offset of latest record.\)

**raftGroup** \(optional\) is the raft group ID specified in function `subscribeTable`. Specify it in `unsubscribeTable` to disable high availability on the subscriber. If the parameter is not specified, the subscription information will be kept in the raft group and the new leader will resubscribe to the stream table.

**Note:** The command `unsubscribeTable` can only be executed on the leader node if the parameter *raftGroup* is specified.

## Details {#details}

Stop subscribing to data from the publisher. All messages of the topic in the message queue of the execution thread will be deleted.

When `unsubscribeTable` is called, unprocessed messages in the queue of the stream execution thread will be deleted.

## Examples {#examples}

Create table "trades" on the publisher.

```python
t=streamTable(100:0,`date`time`sym`qty`price`exch,[DATE,TIME,SYMBOL,INT,DOUBLE,SYMBOL])
share t as trades
t=NULL
```

Create table "trades2" on the subscriber to stream data from table "trades" from the publisher:

```python
t=streamTable(100:0,`date`time`sym`qty`price`exch,[DATE,TIME,SYMBOL,INT,DOUBLE,SYMBOL])
share t as trades2
t=NULL
h=xdb("localhost",8902)
subscribeTable(server=h, tableName="trades", actionName="sub1", handler=trades2);
// output: localhost:8902:node1/trades/sub1
```

To unsubscribe from table "trades":

```
unsubscribeTable(h, "trades","sub1");
```

