# unpack {#unpack}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`unpack(format, buf)`

## Arguments {#arguments}

**format** is a format string.

-   A format character may be preceded by an integral repeat count. For example, the format string '4h' means exactly the same as 'hhhh'.

-   Whitespace characters between formats are ignored; a count and its format must not contain whitespace though.

-   For the 's' format character, the count is interpreted as the length of the bytes, not a repeat count like for the other format characters; for example, '10s' means a single 10-byte string, while '10c' means 10 characters. If a count is not given, it defaults to 1. The string is truncated or padded with null bytes as appropriate to make it fit.


**buf** is a bytes object of STRING or BLOB type. The size of *buf* in bytes must match the size required by the format.

## Details {#details}

Unpack from the *buf* according to the format string specified by *format*. The result is a tuple with the unpacked data even if it contains exactly one item.

## Examples {#examples}

```
res = pack("N",1);
res1 = unpack("N", res);
print(res1)
// output: (1)

res = pack("3s i", `123, 3)
res1 = unpack("3s i",  res);
print(res1)
// output: ("123",3)

res = pack("3s i", `123, 3)
res2 = unpack("3s i",  blob(res));
print(res2)
// output: ("123",3)
```

## Appendix {#appendix}

Please see [Appendix: Format Characters](../appendix.md#) for the format mapping.

The first character of the format string can be used to indicate the byte order, size and alignment of the packed data, see [Appendix: Byte Order, Size, and Alignment](../appendix.md#). If the first character is not one of these characters, '@' is assumed.

Related functions: [pack](../p/pack.md)

