# tupleSum {#tuplesum}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`tupleSum(X)`

## Arguments {#arguments}

**X** is a tuple.

## Details {#details}

Summarize individual results from multiple *map* calls. If each *map* call returns a tuple with *N* non-tuple objects, the input for `tupleSum` function would be a tuple of *N* tuples. Each child tuple contains *m* objects with identical data form and data type, where *m* is the number of *map* calls. If there is a single *map* call, however, `tupleSum` accepts the results of the *map* call as the input, and simply returns the input as the output.

The result of the function `tupleSum` always has the same format as the *map* call result. If the *map* call returns a tuple with at least 2 non-tuple objects, then `tupleSum` returns a tuple containing the same number of non-tuple objects.

## Examples {#examples}

```
x = [(1 2, 3 4, 5 6), (0.5, 0.6, 0.7)];
tupleSum(x);
// output: ([9,12],1.8)
```

If the *map* call return a single non-tuple object, then *tupleSum* also returns a single non-tuple object.

```
x = [(1 2, 3 4, 5 6)];
tupleSum(x);
// output: [9,12]
```

