# trueRange {#truerange}

## Syntax {#syntax}

`trueRange(high, low, close)`

## Arguments {#arguments}

The 3 parameters are numeric vectors of equal length.

Usually, **high** is the highest price of the current period; **low** is the lowest price of the current period; **close** is the closing price of the current period.

## Details {#details}

Return a vector of the same length as each of the input vectors.

The result for each position is the maximum of \| *high* - *low* \|, \| *high* - last period *close* \| and \| last period *close* - *low* \|.

## Examples {#examples}

```
sym=take(`A`B,10)
date=2020.01.01 2020.01.01 2020.01.02 2020.01.02 2020.01.03 2020.01.03 2020.01.04 2020.01.04 2020.01.05 2020.01.05
high=[11.48,10.23,12.26,10.7,12.24,10.45,12.3,10.51,12.24,10.49]
low=[10.91,9.41,11.18,10,11.71,9.83,11.62,9.91,11.1,9.6]
close=[11.38,10.22,12.1,10.31,11.89,10.21,12.13,10.47,11.35,9.81]
t=table(sym,date,high,low,close)
select sym,trueRange(high,low,close) as trange from t context by sym;
```

|sym|trange|
|---|------|
|A||
|A|1.08|
|A|0.53|
|A|0.68|
|A|1.14|
|B||
|B|0.7|
|B|0.62|
|B|0.6|
|B|0.89|

