# triu {#triu}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`triu(X, [k=0])`

## Arguments {#arguments}

**X** is a matrix.

**k** \(optional\) is an integer.

## Details {#details}

If *k* is not specified: return the upper triangular portion of matrix *X*.

If *k* is specified: return the elements on and above the k-th diagonal of *X*.

## Examples {#examples}

```
m=matrix(1 2 3, 4 5 6, 7 8 9);
m;
```

|col1|col2|col3|
|----|----|----|
|1|4|7|
|2|5|8|
|3|6|9|

```
triu(m);
```

|col1|col2|col3|
|----|----|----|
|1|4|7|
|0|5|8|
|0|0|9|

```
triu(m,1);
```

|col1|col2|col3|
|----|----|----|
|0|4|7|
|0|0|8|
|0|0|0|

```
triu(m,-1);
```

|col1|col2|col3|
|----|----|----|
|1|4|7|
|2|5|8|
|0|6|9|

Related function: [tril](tril.md)

