# trima {#trima}

## Syntax {#syntax}

`trima(X, window)`

Please see [TALib](../Themes/TALib.md) for the parameters and windowing logic.

## Details {#details}

Calculate the Triangular Moving Average \(trima\) for *X* in a sliding window of the given length.

The formula is: ![](../../images/trima.png)

where *w1 = \(window + 1\)/2* \(rounded up\); *w2 = \(window + 1\)/2* \(rounded down\).

## Examples {#examples}

```
x=12.1 12.2 12.6 12.8 11.9 11.6 11.2
trima(x,3);
// output: [,,12.274999999999998,18.625,18.662500000000001,15.225000000000001,11.59375]

x=matrix(12.1 12.2 12.6 12.8 11.9 11.6 11.2, 14 15 18 19 21 12 10)
trima(x,3);
```

|col1|col2|
|----|----|
|||
|||
|12.2749|15.5000|
|12.5499|17.5000|
|12.5249|19.2500|
|12.0499|18.2500|
|11.5750|13.7500|

Related functions: [sma](../s/sma.md), [wma](../w/wma.md), [trima](trima.md)

