# triggerNodeReport {#triggernodereport}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`triggerNodeReport(nodeAlias, [chunkId])`

## Arguments {#arguments}

**nodeAlias** is a STRING scalar indicating the node alias.

**chunkId** \(optional\) is a STRING scalar or vector, specifying the chunk\(s\) to be reported. It only takes effect in cluster mode.

## Details {#details}

Force the specified *nodeAlias* to report the chunk information to the controller to update the metadata maintained on the controller. If the *chunkId* is specified, only the specified chunks will be reported.

When to use this function:

This command is used to solve the problem when the chunk information is not reported after a data node is restarted.

1.  Check whether the node is alive with field "state" returned by function `getClusterPerf`.

2.  Check the chunk information with fields "replicas" and "replicaCount" by calling `getClusterChunksStatus`.

3.  If the node is alive but the numbers of replicas do not match, you can search the corresponding chunk ID in the log of the controller. Find out the data node that has not reported and call this command on the node to trigger its report.

4.  If the command does not take effect, please restart the data node.


