# transpose {#transpose}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`transpose(X)`

Alias: `flip`

## Arguments {#arguments}

**X** is a tuple/matrix/table/dictionary/array vector/columnar tuple.

-   If X is a tuple, all elements must be vectors of the same length.
-   If *X* is an array vector or columnar tuple, the number of elements in each row must be the same.

## Details {#details}

This function is used to transpose *X:*

-   If *X* is a tuple: return a tuple of the same length as each element of *X*. The n-th element of the result is a vector composed of the n-th element of each element of *X*.

-   If *X* is a matrix: return the transpose of *X*.

-   If *X* is a table: convert *X* into an ordered dictionary. The dictionary keys are column names. Each dictionary value is a vector of the corresponding column.

-   If *X* is a dictionary: convert *X* into a table. The dictionary keys must be of STRING type:

    -   When values are scalars or vectors of equal length, the keys of *X*serve as the column names and the cooresponding values populate the column values in the table.
    -   When the values are dictionaries, the resulting table will have the keys of X as the first column \(named "key"\). Subsequent columns will be derived from the keys of the first sub-dictionary with each row populated by corresponding values from all nested dictionaries. Missing keys in any sub-dictionary will result in null values in the table.
    **Note:** Dictionaries with more than 32,767 keys cannot be converted into a table.

-   If *X* is an array vector or columnar tuple: switch data from columns to rows, or vice versa.

## Examples {#examples}

Example 1: transpose of a tuple:

```
x=(`A`B`C,1 2 3);
x.transpose();
// output: (("A",1),("B",2),("C",3))
```

Example 2: transpose of a matrix:

```
x=1..6 $ 3:2;
x;
```

|\#0|\#1|
|---|---|
|1|4|
|2|5|
|3|6|

```
transpose x;
```

|\#0|\#1|\#2|
|---|---|---|
|1|2|3|
|4|5|6|

Example 3: convert a table into a dictionary:

```
timestamp = [09:34:07,09:36:42,09:36:51,09:36:59,09:32:47,09:35:26,09:34:16,09:34:26,09:38:12]
sym = `C`MS`MS`MS`IBM`IBM`C`C`C
price= 49.6 29.46 29.52 30.02 174.97 175.23 50.76 50.32 51.29
qty = 2200 1900 2100 3200 6800 5400 1300 2500 8800
t = table(timestamp, sym, qty, price);
t;
```

|timestamp|sym|qty|price|
|---------|---|---|-----|
|09:34:07|C|2200|49.6|
|09:36:42|MS|1900|29.46|
|09:36:51|MS|2100|29.52|
|09:36:59|MS|3200|30.02|
|09:32:47|IBM|6800|174.97|
|09:35:26|IBM|5400|175.23|
|09:34:16|C|1300|50.76|
|09:34:26|C|2500|50.32|
|09:38:12|C|8800|51.29|

```
transpose(t);
/*
timestamp->[09:34:07,09:36:42,09:36:51,09:36:59,09:32:47,09:35:26,09:34:16,09:34:26,09:38:12]
sym->[C,MS,MS,MS,IBM,IBM,C,C,C]
qty->[2200,1900,2100,3200,6800,5400,1300,2500,8800]
price->[49.6,29.46,29.52,30.02,174.97,175.23,50.76,50.32,51.29]
*/
```

Example 4: convert a dictionary into a table:

```
z=dict(`id`val,[`a`b`c,1 2 3]);
z;
/*
val->[1,2,3]
id->[a,b,c]
*/
transpose(z);
```

|val|id|
|---|---|
|1|a|
|2|b|
|3|c|

``` {#codeblock_smv_gxz_21c}
// When the value of a dictionary contains both a scalar and a vector, the scalar will be automatically filled to match the length of the vector.
z1=dict(`id`val,[`a,1 2 3]);
z1;
transpose(z1)
```

|val|id|
|---|---|
|1|a|
|2|a|
|3|a|

Example 5: convert a nested dictionary into a table.

``` {#codeblock_fb2_3xb_d2c}
d = {'tag1':{'val1':2,'val2':6},'tag2':{'val2':1, 'val3':3}}
d
/*
tag1->
    val1->2
    val2->6

tag2->
    val2->1
    val3->3
*/
transpose(d)
```

<table id="table_yr2_jxb_d2c"><thead><tr><th align="left">

key

</th><th align="left">

val1

</th><th align="left">

val2

</th></tr></thead><tbody><tr><td align="left">

tag1

</td><td align="left">

2

</td><td align="left">

6

</td></tr><tr><td align="left">

tag2

</td><td align="left">



</td><td align="left">

1

</td></tr></tbody>
</table>The result shows that after converting the dictionary d into a table, it includes a "key" column and columns named after the keys of the first sub-dictionary \(val1 and val2\). The "key" column contains the keys \(tag1 and tag2\) from d, while the val1 and val2 columns hold the corresponding values from the sub-dictionaries. Since sub-dictionary tag2 lacks val1 key, the corresponding value is null. Additionally, its val3 key is excluded from the resulting table, and the corresponding value is discarded.

