# transDS! {#transds}

## Syntax {#syntax}

`transDS!(ds, tranFunc)`

## Arguments {#arguments}

**ds** is a data source or a list of data sources. It is the sole argument of all the functions in *transFunc*.

**tranFunc** is a function to be applied to *ds*.

## Details {#details}

Apply data transforming functions to a data source or a list of data sources.

## Examples {#examples}

In the following example, the data type of column *trade\_time* from the DFS table "trades1" is converted into NANOTIMESTAMP and inserted into the DFS table "trades2".

```
db=database("dfs://stock1",VALUE,`A`B`C`D)
n=200000
trade_time=2018.01.02T06:12:03.458+1..n
sym=rand(`A`B`C`D,n)
qty=rand(100.0,n)
price=rand(100.0,n)
t=table(trade_time,sym,qty,price)
trades1=db.createPartitionedTable(t,`trades1,`sym).append!(t);

ds=sqlDS(<select * from trades1>);

def convertNanotimestamp(t){
   return select nanotimestamp(trade_time), sym, qty, price from t
}

ds.transDS!(convertNanotimestamp);

db=database("dfs://stock2",VALUE,`A`B`C`D)
t=table(1:0,`trade_time`sym`qty`price,[NANOTIMESTAMP,SYMBOL,DOUBLE,DOUBLE])
trades2=db.createPartitionedTable(t,`trades2,`sym);

mr(ds,append!{trades2},,,false);

exec count(*) from trades2;
// output: 200000
```

