# topRange {#toprange}

## Syntax {#syntax}

`topRange(X)`

## Arguments {#arguments}

**X** is a vector/tuple/matrix/table

## Details {#details}

For each element *Xi* in *X*, count the continuous nearest neighbors to its left that are smaller than *Xi*.

For each element in X, the function return the maximum length of a window to the left of *X* where it is the max/min. For example, after how many days a stock hits a new high.

## Examples {#examples}

```
topRange([13.5, 13.6, 13.4, 13.3, 13.5, 13.9, 13.1, 20.1, 20.2, 20.3])
// output: [0,1,0,0,2,5,0,7,8,9]

m = matrix(1.5 2.6 3.2 1.4 2.5 2.2 3.7 2.0, 1.6 2.3 4.2 5.6 4.1 3.2 4.4 6.9)
topRange(m)
```

|\#0|\#1|
|---|---|
|0|0|
|1|1|
|2|2|
|0|3|
|1|0|
|0|0|
|6|2|
|0|7|

```
//Simulate the stock price of stock A for 8 days. Use topRange to calculate after how many days the stock hit a new high
trades = table(take(`A, 8) as sym,  2022.01.01 + 1..8 as date, 39.70 39.72 39.80 39.78 39.83 39.92 40.00 40.03 as price)
select *, topRange(price) from trades
```

|id|date|price|topRange\_price|
|---|----|-----|---------------|
|A|2022.01.02|39.7|0|
|A|2022.01.03|39.72|1|
|A|2022.01.04|39.8|2|
|A|2022.01.05|39.78|0|
|A|2022.01.06|39.83|4|
|A|2022.01.07|39.92|5|
|A|2022.01.08|40|6|
|A|2022.01.09|40.03|7|

Related function: [lowRange](../l/lowRange.md)

