# toJson {#tojson}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`toJson(X)`

## Arguments {#arguments}

**X** can be any data type.

## Details {#details}

Convert a DolphinDB object to JSON format. The result includes 5 key-value pairs: name, form, type, size and value.

For different data forms, the maximum length of the data to be converted differs:

|Data Forms|Max Length|
|----------|----------|
|matrix|300000|
|set|300000|
|vector|300000|
|dict|300000|
|table|100000|

## Examples {#examples}

```
x=1 2 3
y=toJson(x)
y;
// output: {"name":"x","form":"vector","type":"int","size":"3","value":[1,2,3]}

t=table(1 2 3 as id, 10 20 30 as val)
toJson(t);
// output: {"name":"t","form":"table","size":"3","value":[{"name":"id","form":"vector","type":"int","size":"3","value":[1,2,3]},{"name":"val","form":"vector","type":"int","size":"3","value":[10,20,30]}]}

// The length of set exceeds 30000, and toJson can only convert the first 30000 elements
x=set(1..400001)
y=toJson(x)
size(fromJson(y))
// output: 300000
```

Related function: [fromJson](../f/fromJson.md)

