# tmwavg {#tmwavg}

## Syntax {#syntax}

`tmwavg(T, X, Y, window)`

Please see [tmFunctions](../Themes/tmFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the moving average of *X* with *Y* as weights in a sliding window.

The weights in a sliding window are automatically adjusted so that the sum of weights for all non-Null elements in the sliding window is 1.

## Examples {#examples}

```
T= 1 1 1 1 2 5 6 8 9 10
X = 1..10
Y = double(1..10)\10
m = table(T as t,X as x, Y as y)
select *, tmwavg(t, x, y, 3) from m
```

|t|x|y|tmwavg\_t|
|---|---|---|---------|
|1|1|0.1|1|
|1|2|0.2|1.6667|
|1|3|0.3|2.3333|
|1|4|0.4|3|
|2|5|0.5|3.6667|
|5|6|0.6|6|
|6|7|0.7|6.5385|
|8|8|0.8|7.5333|
|9|9|0.9|8.5294|
|10|10|1|9.0741|

```
T = 2021.01.02 2021.01.06 join 2021.01.07..2021.01.14
X = 1..10
Y = double(1..10)\10
m=table(T as t,X as x, Y as y)
select *, tmwavg(t, y, x, 3) from m
```

|t|x|y|tmwavg\_t|
|---|---|---|---------|
|2021.01.02|1|0.1|0.1|
|2021.01.06|2|0.2|0.2|
|2021.01.07|3|0.3|0.26|
|2021.01.08|4|0.4|0.3222|
|2021.01.09|5|0.5|0.4167|
|2021.01.10|6|0.6|0.5133|
|2021.01.11|7|0.7|0.6111|
|2021.01.12|8|0.8|0.7095|
|2021.01.13|9|0.9|0.8083|
|2021.01.14|10|1|0.9074|

```
select *, tmwavg(t, y, x, 1w) from m
```

|t|x|y|tmwavg\_t|
|---|---|---|---------|
|2021.01.02|1|0.1|0.1|
|2021.01.06|2|0.2|0.1667|
|2021.01.07|3|0.3|0.2333|
|2021.01.08|4|0.4|0.3|
|2021.01.09|5|0.5|0.3857|
|2021.01.10|6|0.6|0.45|
|2021.01.11|7|0.7|0.5148|
|2021.01.12|8|0.8|0.58|
|2021.01.13|9|0.9|0.6667|
|2021.01.14|10|1|0.7571|

Related functions: [wavg](../w/wavg.md), [mwavg](../m/mwavg.md)

