# tmvar {#tmvar}

## Syntax {#syntax}

`tmvar(T, X, window)`

Please see [tmFunctions](../Themes/tmFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the moving variance of *X* in a sliding window.

## Examples {#examples}

```
T = 1 1 3 5 8 15 15 20
X = 5 2 4 1 2 8 9 10
m=table(T as t, X as x)
select *, tmvar(t, x, 3) from m
```

|t|x|tmvar\_t|
|---|---|--------|
|1|5||
|1|2|4.5|
|3|4|2.3333|
|5|1|4.5|
|8|2||
|15|8||
|15|9|0.5|
|20|10||

```
T = 2021.01.02 2021.01.02  2021.01.04  2021.01.05 2021.01.07 2021.01.08
X = NULL 4 NULL -1 2 4
m = table(T as t,X as x)
select *, tmvar(t, x, 3d) from m
```

|t|x|tmvar\_t|
|---|---|--------|
|2021.01.02|||
|2021.01.02|4||
|2021.01.04|||
|2021.01.05|-1||
|2021.01.07|2|4.5|
|2021.01.08|4|2|

```
select *, tmvar(t, x, 1w) from m
```

|t|x|tmvar\_t|
|---|---|--------|
|2021.01.02|||
|2021.01.02|4||
|2021.01.04|||
|2021.01.05|-1|12.5|
|2021.01.07|2|6.333|
|2021.01.08|4|5.5833|

Related Functions: [mvar](../m/mvar.md), [var](../v/var.md)

