# tmsumTopN {#tmsumtopn}

## Syntax {#syntax}

`tmsumTopN(T, X, S, window, top, [ascending=true], [tiesMethod='latest'])`

Please see [tmTopN](../Themes/tmTopN.md) for the parameters and windowing logic.

## Details {#details}

Within a sliding window of given length \(measured by time\), the function stably sorts *X* by *S* in the order specified by *ascending*, then sums up the first *top* elements.

**Return value**:

-   If *X* is an integer, a vector of LONG type is returned.

-   If *X* is a floating-point number, a vector of DOUBLE type is returned.


## Examples {#examples}

```
T=2023.01.03+1..7
X = [2, 1, 4, 3, 4, 3, 1]
S = [5, 8, 1, , 1, 1, 3]
// The null values in S are ignored in data sorting, and the corresponding elements in X do not participate in calculation
tmsumTopN(T,X,S,6,4)
// output: [2,3,7,7,11,13,12]

T=2023.01.03 2023.01.07 2023.01.08 2023.01.10 2023.01.11 2023.01.12
X=8 3 1 2 5 2
S=1 5 2 3 1 1
t=table(T as time, X as val, S as id)
select tmsumTopN(time,val,id,4,3) as topN from t
```

|topN|
|----|
|8|
|3|
|4|
|6|
|8|
|9|

Related function: [tmsum](tmsum.md)

