# tmsum2 {#tmsum2}

## Syntax {#syntax}

`tmsum2(T, X, window)`

Please see [tmFunctions](../Themes/tmFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the moving sum of squares of all elements of *X* in a sliding window.

**Return value**: a vector of DOUBLE type

## Examples {#examples}

```
tmsum2(1 1 3 5 8 15 15 20, 5 2 4 1 2 8 9 10, 3)
// output: [25,29,45,17,4,64,145,100]

index = take(datehour(2019.06.13 13:30:10),4) join (datehour(2019.06.13 13:30:10)+1..6)
data = 1 NULL 3 4 5 NULL 3 NULL 5 3
tmsum2(index, data, 4h)
// output: [1,1,10,26,51,51,60,34,34,43]

tmsum2(index, data, 1d)
// output: [1,1,10,26,51,51,60,60,85,94]
```

Related Functions: [sum2](../s/sum2.md)

