# tmstd {#tmstd}

## Syntax {#syntax}

`tmstd(T, X, window)`

Please see [tmFunctions](../Themes/tmFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the standard deviation of *X* in a sliding window.

## Examples {#examples}

```
T = 1 1 3 5 8 15 15 20
X = 5 2 4 1 2 8 9 10
m=table(T as t, X as x)
select *, tmstd(t, x, 3) from m
```

|t|x|tmstd\_t|
|---|---|--------|
|1|5||
|1|2|2.1213|
|3|4|1.5275|
|5|1|2.1213|
|8|2||
|15|8||
|15|9|0.7071|
|20|10||

```
T = 2021.01.02 2021.01.02  2021.01.04  2021.01.05 2021.01.07 2021.01.08
X = NULL 4 NULL -1 2 4
m = table(T as t,X as x)
select *, tmstd(t, x, 3d) from m
```

|t|x|tmstd\_t|
|---|---|--------|
|2021.01.02|||
|2021.01.02|4||
|2021.01.04|||
|2021.01.05|-1||
|2021.01.07|2|2.1213|
|2021.01.08|4|1.4142|

```
select *, tmstd(t, x, 1w) from m
```

|t|x|tmstd\_t|
|---|---|--------|
|2021.01.02|||
|2021.01.02|4||
|2021.01.04|||
|2021.01.05|-1|3.5355|
|2021.01.07|2|2.5166|
|2021.01.08|4|2.3629|

Related Functions: [mstd](../m/mstd.md), [std](../s/std.md)

