# tmskew {#tmskew}

## Syntax {#syntax}

`tmskew(T, X, window, [biased=true])`

Please see [tmFunctions](../Themes/tmFunctions.md) for the common parameters and windowing logic.

## Parameters {#parameters}

**biased** \(optional\) is a Boolean value indicating whether the result is biased. The default value is true, meaning the bias is not corrected.

## Details {#details}

Calculate the moving skewness of *X* in a sliding window.

## Examples {#examples}

```
tmskew(1 1 3 5 8 15 15 20, 5 2 4 1 2 8 9 10, 3)
// output: [,0,-0.381801774160607,0,,,0,]

index = take(datehour(2019.06.13 13:30:10),4) join (datehour(2019.06.13 13:30:10)+1..6)
data = 1 NULL 3 4 5 NULL 3 NULL 5 3
tmskew(index, data, 4h)
// output: [,,,-0.3818,,,0,0,0,0.7071]

tmskew(index, data, 2d)
// output: [,,0,-0.3818,-0.4347,-0.4347,-0.37,-0.37,-0.5653,-0.4363]
```

Related Functions: [mskew](../m/mskew.md), [skew](../s/skew.md)

