# tmrank {#tmrank}

## Syntax {#syntax}

`tmrank(T, X, ascending, window, [ignoreNA=true], [tiesMethod='min'], [percent=false])`

Please see [tmFunctions](../Themes/tmFunctions.md) for the common parameters and windowing logic.

## Arguments {#arguments}

**ascending** is a Boolean value. The default value is true indicating the sorting direction is ascending.

**ignoreNA** \(optional\) is a Boolean value indicating whether null values are ignored in ranking. The default value is true. If null values participate in the ranking, they are ranked the lowest.

**tiesMethod** \(optional\) is a string indicating how to rank the group of records with the same value \(i.e., ties\):

-   "min": lowest rank of the group

-   "max": highest rank of the group

-   "average": average rank of the group


**percent** is a Boolean value, indicating whether to display the returned rankings in percentile form. The default value is false.

## Details {#details}

Return the rank of each element of *X* in a sliding window.

## Examples {#examples}

```
tmrank(1 1 3 5 8 15 15 20, 5 2 4 1 2 8 9 10, ascending=true, window=3)
// output: [0,0,1,0,0,0,1,0]

index = take(datehour(2019.06.13 13:30:10),4) join (datehour(2019.06.14 13:30:10)+1..6)
data = 1 NULL 3 4 5 NULL 3 NULL 5 3

tmrank(index, data, ascending=true, window=4h)
// output: [0,,1,2,0,,0,,1,0]

tmrank(index, data, ascending=true, window=2d)
// output: [0,,1,2,3,,1,,4,1]
```

Related functions: [mrank](../m/mrank.md), [rank](../r/rank.md)

