# tmprod {#tmprod}

## Syntax {#syntax}

`tmprod(T, X, window)`

Please see [tmFunctions](../Themes/tmFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the moving product of *X* in a sliding window.

## Examples {#examples}

```
T = 1 1 3 5 8 15 15 20
X = 5 2 4 1 2 8 9 10
m=table(T as t, X as x)
select *, tmprod(t, x, 3) from m
```

|t|x|tmprod\_t|
|---|---|---------|
|1|5|5|
|1|2|10|
|3|4|40|
|5|1|4|
|8|2|2|
|15|8|8|
|15|9|72|
|20|10|10|

```
T = 2021.01.02 2021.01.02  2021.01.04  2021.01.05 2021.01.07 2021.01.08
X = NULL 4 NULL -1 2 4
m = table(T as t,X as x)
select *, tmprod(t, x, 3d) from m
```

|t|x|tmprod\_t|
|---|---|---------|
|2021.01.02|||
|2021.01.02|4|4|
|2021.01.04||4|
|2021.01.05|-1|-1|
|2021.01.07|2|-2|
|2021.01.08|4|8|

```
select *, tmprod(t, x, 1w) from m
```

|t|x|tmprod\_t|
|---|---|---------|
|2021.01.02|||
|2021.01.02|4|4|
|2021.01.04||4|
|2021.01.05|-1|-1|
|2021.01.07|2|-2|
|2021.01.08|4|8|

Related functions: [mprod](../m/mprod.md), [prod](../p/prod.md)

