# tmmed {#tmmed}

## Syntax {#syntax}

`tmmed(T, X, window)`

Please see [tmFunctions](../Themes/tmFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the moving median of *X* in a sliding window.

## Examples {#examples}

```
T = 1 1 1 2 5 6
X = 1 4 NULL -1 NULL 4
m = table(T as t,X as x)
select *, tmmed(t, x, 3) from m
```

|t|x|tmmed\_t|
|---|---|--------|
|1|1|1|
|1|4|2.5|
|1||2.5|
|2|-1|1|
|5|||
|6|4|4|

```
T = 2021.01.02 2021.01.02  2021.01.04  2021.01.05 2021.01.07 2021.01.08
X = NULL 4 NULL -1 2 4
m = table(T as t,X as x)
select *, tmmed(t, x, 3d) from m
```

|t|x|tmmed\_t|
|---|---|--------|
|2021.01.02|||
|2021.01.02|4|4|
|2021.01.04||4|
|2021.01.05|-1|-1|
|2021.01.07|2|0.5|
|2021.01.08|4|3|

```
select *, tmmed(t, x, 1w) from m
```

|t|x|tmmed\_t|
|---|---|--------|
|2021.01.02|||
|2021.01.02|4|4|
|2021.01.04||4|
|2021.01.05|-1|1.5|
|2021.01.07|2|2|
|2021.01.08|4|3|

Related functions: [mmed](../m/mmed.md), [med](../m/med.md)

