# tmkurtosisTopN {#tmkurtosistopn}

## Syntax {#syntax}

`tmkurtosisTopN(T, X, S, window, top, [biased=true], [ascending=true], [tiesMethod='latest'])`

## Arguments {#arguments}

**biased** \(optional\) is a Boolean value indicating whether the result is biased. The default value is true, meaning the bias is not corrected.

Please see [tmTopN](../Themes/tmTopN.md) for the parameters and windowing logic.

## Details {#details}

Within a sliding window of given length \(measured by time\), the function stably sorts *X* by *S* in the order specified by *ascending*, then calculates the moving kurtosis of the first *top* elements.

**Return value**: a vector of DOUBLE type

## Examples {#examples}

```
T=2023.01.03+1..10
X = [2, 1, 4, 3, 4, 3, 1, 5, 8, 2]
S = [5, 8, 1, , 1, 1, 3, 2, 5 ,1]
// The null values in S are ignored in data sorting, and the corresponding elements in X do not participate in calculation
tmkurtosisTopN(T,X,S,6,4)
// output: [,,1.5,1.5,1.2798,1.628,2,2,1.8457,1.64]

T=2023.01.03 2023.01.07 2023.01.08 2023.01.10 2023.01.11 2023.01.12 2023.01.13 2023.01.14 2023.01.15 2023.01.16
X=8 3 1 2 5 2 5 4 2 6
S=1 5 2 3 1 1 2 4 5 3
t=table(T as time, X as val, S as id)
select tmkurtosisTopN(time,val,id,6,4) as topN from t
```

|topN|
|----|
||
||
|1.5|
|1.5|
|1.8457|
|2.1852|
|1.1522|
|1|
|1|
|2.1852|

Related function: [tmkurtosis](tmkurtosis.md)

