# tmkurtosis {#tmkurtosis}

## Syntax {#syntax}

`tmkurtosis(T, X, window, [biased=true])`

Please see [tmFunctions](../Themes/tmFunctions.md) for the common parameters and windowing logic.

## Parameters {#parameters}

**biased** \(optional\) is a Boolean value indicating whether the result is biased. The default value is true, meaning the bias is not corrected.

## Details {#details}

Calculate the moving kurtosis of *X* in a sliding window.

## Examples {#examples}

```
T = 1 1 1 2 5 6
X = 1 4 NULL -1 NULL 4
m = table(T as t, X as x)
select *, tmkurtosis(t, x, 3) from m
```

|t|x|tmkurtosis\_t|
|---|---|-------------|
|1|1||
|1|4||
|1|||
|2|-1|1.5|
|5|||
|6|4||

```
T = take(datehour(2019.06.13 13:30:10),4) join (datehour(2019.06.13 13:30:10)+1..6)
X = 1 NULL 3 4 5 NULL 3 NULL 5 3
m = table(T as t,X as x)
select *, tmkurtosis(t, x, 3d) from m
```

|t|x|tmkurtosis\_t|
|---|---|-------------|
|2019.06.13T13|1||
|2019.06.13T13|||
|2019.06.13T13|3||
|2019.06.13T13|4|1.5|
|2019.06.13T14|5|1.8457|
|2019.06.13T15||1.8457|
|2019.06.13T16|3|2.2169|
|2019.06.13T17||2.2169|
|2019.06.13T18|5|2.2401|
|2019.06.13T19|3|2.4072|

```
select *, tmkurtosis(t, x, 1w) from m
```

|t|x|tmkurtosis\_t|
|---|---|-------------|
|2019.06.13T13|1||
|2019.06.13T13|||
|2019.06.13T13|3||
|2019.06.13T13|4|1.5|
|2019.06.13T14|5|1.8457|
|2019.06.13T15||1.8457|
|2019.06.13T16|3|2.2169|
|2019.06.13T17||2.2169|
|2019.06.13T18|5|2.2401|
|2019.06.13T19|3|2.4072|

Related Functions: [mkurtosis](../m/mkurtosis.md), [kurtosis](../k/kurtosis.md)

