# tmcovar {#tmcovar}

## Syntax {#syntax}

`tmcovar(T, X, Y, window)`

Please see [tmFunctions](../Themes/tmFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the moving covariance of *X* and *Y* in a sliding window.

## Examples {#examples}

```
T = 1 1 1 2 5 6
X = 1 4 2 -1 2 4
Y = 2 5 -3 6 9 1
m = table(T as t,X as x, Y as y)
select *, tmcovar(t, y, x, 3) from m
```

|t|x|y|tmcovar\_t|
|---|---|---|----------|
|1|1|2||
|1|4|5|4.5|
|1|2|-3|3.3333|
|2|-1|6|-1.6667|
|5|2|9||
|6|4|1|-8|

```
T = 2021.01.02 2021.01.02  2021.01.04  2021.01.05 2021.01.07 2021.01.08
X = 1 4 2 -1 2 4
Y = 2 5 -3 6 9 1
m = table(T as t,X as x, Y as y)
select *, tmcovar(t, y, x, 3d) from m
```

|t|x|y|tmcovar\_t|
|---|---|---|----------|
|2021.01.02|1|2||
|2021.01.02|4|5|4.5|
|2021.01.04|2|-3|3.3333|
|2021.01.05|-1|6|-13.5|
|2021.01.07|2|9|4.5|
|2021.01.08|4|1|-8|

```
select *, tmcovar(t, y, x, 1w) from m
```

|t|x|y|tmcovar\_t|
|---|---|---|----------|
|2021.01.02|1|2||
|2021.01.02|4|5|4.5|
|2021.01.04|2|-3|3.3333|
|2021.01.05|-1|6|-1.6667|
|2021.01.07|2|9|-0.6|
|2021.01.08|4|1|-1.6|

Related Functions: [mcovar](../m/mcovar.md), [covar](../c/covar.md)

