# tmcount {#tmcount}

## Syntax {#syntax}

`tmcount(T, X, window)`

Please see [tmFunctions](../Themes/tmFunctions.md) for the parameters and windowing logic.

## Details {#details}

Return the number of non-null values of *X* in a sliding window.

## Examples {#examples}

```
T = 1 1 1 2 5 6
X = 1 4 NULL -1 NULL 4
m = table(T as t,X as x)
select *, tmcount(t, x, 3) from m
```

|t|x|tmcount\_t|
|---|---|----------|
|1|1|1|
|1|4|2|
|1||2|
|2|-1|3|
|5||0|
|6|4|1|

```
T = 2021.01.02 2021.01.02  2021.01.04  2021.01.05 2021.01.07 2021.01.09
X = NULL 4 NULL -1 2 4
m = table(T as t,X as x)
select *, tmcount(t, x, 3d) from m
```

|t|x|tmcount\_t|
|---|---|----------|
|2021.01.02||0|
|2021.01.02|4|1|
|2021.01.04||1|
|2021.01.05|-1|1|
|2021.01.07|2|2|
|2021.01.09|4|2|

```
select *, tmcount(t, x, 1w) from m
```

|t|x|tmcount\_t|
|---|---|----------|
|2021.01.02||0|
|2021.01.02|4|1|
|2021.01.04||1|
|2021.01.05|-1|2|
|2021.01.07|2|3|
|2021.01.09|4|3|

Related Functions: [mcount](../m/mcount.md), [count](../c/count.md)

