# tmcorr {#tmcorr}

## Syntax {#syntax}

`tmcorr(T, X, Y, window)`

Please see [tmFunctions](../Themes/tmFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the correlation of *X* and *Y* in a sliding window.

## Examples {#examples}

```
T = 1 1 1 2 5 6
X = 1 4 2 -1 2 4
Y = 2 5 -3 6 9 1
m = table(T as t,X as x, Y as y)
select *, tmcorr(t, y, x, 3) from m
```

|t|x|y|tmcorr\_t|
|---|---|---|---------|
|1|1|2||
|1|4|5|1|
|1|2|-3|0.5399|
|2|-1|6|-0.1981|
|5|2|9||
|6|4|1|-1|

```
T = 2021.01.02 2021.01.02  2021.01.04  2021.01.05 2021.01.07 2021.01.08
X = 1 4 2 -1 2 4
Y = 2 5 -3 6 9 1
m = table(T as t,X as x, Y as y)
select *, tmcorr(t, y, x, 3d) from m
```

|t|x|y|tmcorr\_t|
|---|---|---|---------|
|2021.01.02|1|2||
|2021.01.02|4|5|1|
|2021.01.04|2|-3|0.5399|
|2021.01.05|-1|6|-1|
|2021.01.07|2|9|1|
|2021.01.08|4|1|-1|

```
select *, tmcorr(t, y, x, 1w) from m
```

|t|x|y|tmcorr\_t|
|---|---|---|---------|
|2021.01.02|1|2||
|2021.01.02|4|5|1|
|2021.01.04|2|-3|0.5399|
|2021.01.05|-1|6|-0.1981|
|2021.01.07|2|9|-0.0726|
|2021.01.08|4|1|-0.1995|

Related Functions: [mcorr](../m/mcorr.md), [corr](../c/corr.md)

