# tmbeta {#tmbeta}

## Syntax {#syntax}

`tmbeta(T, Y, X, window)`

Please see [tmFunctions](../Themes/tmFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the coefficient estimate of an ordinary-least-squares regression of *Y* on *X* in a sliding window.

## Details {#details-1}

```
T = 1 1 1 2 5 6
X = 1 4 2 -1 2 4
Y = 2 5 -3 6 9 1
m = table(T as t,X as x, Y as y)
select *, tmbeta(t, y, x, 3) from m
```

|t|x|y|tmbeta\_t|
|---|---|---|---------|
|1|1|2||
|1|4|5|1|
|1|2|-3|1.4286|
|2|-1|6|-0.3846|
|5|2|9||
|6|4|1|-4|

```
T = 2021.01.02 2021.01.02  2021.01.04  2021.01.05 2021.01.07 2021.01.08
X = 1 4 2 -1 2 4
Y = 2 5 -3 6 9 1
m = table(T as t,X as x, Y as y)
select *, tmbeta(t, y, x, 3d) from m
```

|t|x|y|tmbeta\_t|
|---|---|---|---------|
|2021.01.02|1|2||
|2021.01.02|4|5|1|
|2021.01.04|2|-3|1.4286|
|2021.01.05|-1|6|-3|
|2021.01.07|2|9|1|
|2021.01.08|4|1|-4|

```
select *, tmbeta(t, y, x, 1w) from m
```

|t|x|y|tmbeta\_t|
|---|---|---|---------|
|2021.01.02|1|2||
|2021.01.02|4|5|1|
|2021.01.04|2|-3|1.4286|
|2021.01.05|-1|6|-0.3846|
|2021.01.07|2|9|-0.1818|
|2021.01.08|4|1|-0.4444|

Related Functions: [mbeta](../m/mbeta.md), [beta](../b/beta.md)

