# tmavgTopN {#tmavgtopn}

## Syntax {#syntax}

`tmavgTopN(T, X, S, window, top, [ascending=true], [tiesMethod='latest'])`

Please see [tmTopN](../Themes/tmTopN.md) for the parameters and windowing logic.

## Details {#details}

Within a sliding window of given length \(measured by time\), the function stably sorts *X* by *S* in the order specified by *ascending*, then calculates the average of the first *top* elements.

**Return value**: a vector of DOUBLE type

## Examples {#examples}

```
T=2023.01.03+1..7
X = [2, 1, 4, 3, 4, 3, 1]
S = [5, 8, 1, , 1, 1, 3]
// The null values in S are ignored in data sorting, and the corresponding elements in X do not participate in calculation
tmavgTopN(T,X,S,6,4)
// output: [2,1.5,2.3333,2.3333,2.75,3.25,3]

T=2023.01.03 2023.01.07 2023.01.08 2023.01.10 2023.01.11 2023.01.12
X=8 3 1 2 5 2
S=1 5 2 3 1 1
t=table(T as time, X as val, S as id)
select tmavgTopN(time,val,id,4,3) as topN from t
```

|topN|
|----|
|8|
|3|
|2|
|2|
|2.6666|
|3|

Related function: [tmavg](tmavg.md)

