# til {#til}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`til(n)`

## Arguments {#arguments}

**n** is a non-negative integer.

## Details {#details}

Return a vector of integral type from 0 to n-1. If n=0, return an empty vector.

The result is of the same data type as n. For example, if n is of LONG type, return a FAST LONG VECTOR.

## Examples {#examples}

```
til(0);
// output: []

til(5);
// output: [0,1,2,3,4]

n = 10;
t = table(2022.01.01 + til(n) as date, rand(10.0, n) as val);
t;
/* output:
date        val
2022.01.01  8.403
2022.01.02  9.424
2022.01.03  0.4779
2022.01.04  1.8934
2022.01.05  9.6637
2022.01.06  1.7993
2022.01.07  7.1143
2022.01.08  8.3044
2022.01.09  2.6919
2022.01.10  1.9294
*/
```

Related functions: [take](take.md), [rand](../r/rand.md)

