# temporalSeq {#temporalseq}

## Syntax {#section_qgb_1pv_bzb .section}

`temporalSeq(start, end, rule, [closed], [label], [origin='start_day'])`

## Details {#section_dzr_1pv_bzb .section}

Resample the time series between start and end based on the frequency specified by *rule*.

**Return value**: a vector of temporal type.

## Arguments {#section_zw4_bpv_bzb .section}

**start** is a temporal scalar.

**end** is a temporal scalar. Its data type must be the same as *start*, and its value must be greater than *start*.

**rule** is a string that can take the following values:

|Values of *rule*|DolphinDB function|
|----------------|------------------|
|"B"|businessDay|
|"W"|weekEnd|
|"WOM"|weekOfMonth|
|"LWOM"|lastWeekOfMonth|
|"M"|monthEnd|
|"MS"|monthBegin|
|"BM"|businessMonthEnd|
|"BMS"|businessMonthBegin|
|"SM"|semiMonthEnd|
|"SMS"|semiMonthBegin|
|"Q"|quarterEnd|
|"QS"|quarterBegin|
|"BQ"|businessQuarterEnd|
|"BQS"|businessQuarterBegin|
|"REQ"|fy5253Quarter|
|"A"|yearEnd|
|"AS"|yearBegin|
|"BA"|businessYearEnd|
|"BAS"|businessYearBegin|
|"RE"|fy5253|
|"D"|date|
|"H"|hourOfDay|
|"U"|microsecond|
|"L"|millisecond|
|"min"|minuteOfHour|
|"N"|nanosecond|
|"S"|secondOfMinute|
|"SA"|semiannualEnd|
|"SAS"|semiannualBegin|

The strings above can also be used with integers for parameter "rule". For example, "2M" means the end of every two months. In addition, *rule* can also be set as the identifier of the trading calendar, e.g., the Market Identifier Code of an exchange, or a user-defined calendar name.

**closed** \(optional\) is a string indicating which boundary of the interval is closed.

-   The default value is 'left' for all values of *rule* except for 'M', 'A', 'Q', 'BM', 'BA', 'BQ', and 'W' which all have a default of 'right'.

-   The default is 'right' if *origin* is 'end' or 'end\_day'.


**label** \(optional\) is a string indicating which boundary is used to label the interval.

-   The default value is 'left' for all values of *rule* except for 'M', 'A', 'Q', 'BM', 'BA', 'BQ', and 'W' which all have a default of 'right'.

-   The default is 'right' if *origin* is 'end' or 'end\_day'.


**origin** \(optional\) is a string or a scalar of the same data type as *X*, indicating the timestamp where the intervals start. It can be 'epoch', start', 'start\_day', 'end', 'end\_day' or a user-defined time object. The default value is 'start\_day'.

-   'epoch': *origin* is 1970-01-01

-   'start': *origin* is the first value of the timeseries

-   'start\_day': *origin* is 00:00 of the first day of the timeseries

-   'end': *origin* is the last value of the timeseries

-   'end\_day': *origin* is 24:00 of the last day of the timeseries


## Examples {#section_vyy_cpv_bzb .section}

``` {#codeblock_wjm_dpv_bzb}
temporalSeq(start=2022.01.01 00:01:00,end=2022.01.01 00:08:00,rule="3min")
// output: [2022.01.01T00:00:00,2022.01.01T00:03:00,2022.01.01T00:06:00]
    
temporalSeq(start=2022.01.01 00:01:00, end=2022.01.01 00:08:00, rule="3min", closed=`right)
// output: [2022.01.01T00:00:00,2022.01.01T00:03:00,2022.01.01T00:06:00]
    
temporalSeq(start=2022.01.01 00:01:00, end=2022.01.01 00:08:00, rule="3min", closed=`right, origin=`end)
// output: [2022.01.01T00:02:00,2022.01.01T00:05:00,2022.01.01T00:08:00]
    
temporalSeq(start=2022.01.01 00:01:00, end=2022.01.01 00:08:00, rule="3min", closed=`right, origin=2022.10.01 00:00:10)
// output: [2022.01.01T00:00:10,2022.01.01T00:03:10,2022.01.01T00:06:10]
```

**Parent topic:**[Functions](../../Functions/category.md)

