# temporalDiff {#temporalDiff}

Alias:`datetimeDiff`

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`temporalDiff(X, Y, [unit])`

## Arguments {#arguments}

**X** can be a temporal value, a vector or matrix of temporal values, or a table containing temporal column\(s\).

**Y** is a scalar/vector/matrix/table matching the length or dimensions of *X*. The type of *Y* must exactly match that of *X*.

**unit** \(optional\) is a string that specifies the time unit for the calculation. Valid values are:

-   "d" for calendar days
-   "B" for business days
-   A trading calendar identifier \(e.g., "XNYS"\), where the corresponding calendar file must be located in the directory specified by the *marketHolidayDir*configuration.

**Note:** If *unit* is specified, *X* and *Y* must be of type DATE.

## Details {#details}

The `temporalDiff` function calculates the time difference between *X* and *Y*.

When the optional *unit*parameter is provided, the time differences are calculated based on the specified time unit \(calendar days, business days, or trading days for a specific exchange\).

**Return value**: A vector/matrix/table with the same shape as *X*.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
timestamps = [13:30:49,13:30:39,13:30:50,13:30:57,13:30:35]
temporalDiff(timestamps, 13:30:00)
// Output: [49,39,50,57,35]
```

If *unit* is specified, *X* and *Y* must be of type DATE.

``` {#codeblock_epk_csj_gfc}
dates = [2019.12.31, 2020.01.03, 2020.01.10, 2020.01.15, 2020.01.17]

temporalDiff(dates, 2019.12.30, "d") // Output: [1,4,11,16,18]
temporalDiff(dates, 2019.12.30, "B") // Output: [1,4,9,12,14]
temporalDiff(dates, 2019.12.30, "XNYS") // Output: [1,3,8,11,13]
```

