# temporalDeltas {#temporalDeltas}

Alias: datetimeDeltas

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`temporalDeltas(X, [unit])`

## Arguments {#arguments}

**X** is a vector or matrix of temporal values, or a table containing temporal column\(s\).

**unit** \(optional\) is a string that specifies the time unit for the calculation. Valid values are:

-   "d" for calendar days

-   "B" for business days

-   A trading calendar identifier \(e.g., "XNYS"\), where the corresponding calendar file must be located in the directory specified by the *marketHolidayDir*configuration.


**Note:** If *unit* is specified, *X* must be of type DATE.

## Details {#details}

For each temporal type element *Xi* in *X*, return*Xi*-*Xi-1*, representing the time differences between elements. NULL values always return NULL during the calculation, and the first output value is always NULL.

When the optional *unit*parameter is provided, the time differences are calculated based on the specified time unit \(calendar days, business days, or trading days for a specific exchange\).

**Return value**: A vector/matrix/table with the same shape as *X*.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
timestamps = [2020.06.13T13:30:10.000, 2020.06.13T13:30:10.010, 2020.06.13T13:30:10.021, 2020.06.13T13:30:10.033, 2020.06.13T13:30:10.046]
temporalDeltas(timestamps)
// Output: [,10,11,12,13]
```

If *unit* is specified, *X* must be of type DATE:

``` {#codeblock_wdg_yrj_gfc}
times = [2019.12.31, 2020.01.03, 2020.01.10, 2020.01.15, 2020.01.17]
temporalDeltas(times, "d");
// Output: [NULL, 3, 7, 5, 2] 

temporalDeltas(times, "B");
// Output: [NULL, 3, 5, 3, 2] 

temporalDeltas(times, "XNYS");
// Output: [NULL, 2, 5, 3, 2]

sym = `A`B`C`D`E
num = 5 4 3 2 1
t = table(times, sym, num)
temporalDeltas(t);

/*
times sym num
----- --- ---
      A   5  
3     B   4  
7     C   3  
5     D   2  
2     E   1  
*/
```

