# tanimoto {#tanimoto}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`tanimoto(X, Y)`

## Arguments {#arguments}

**X** and **Y** are numeric scalars, or vectors/matrices of the same size.

## Details {#details}

If *X* and *Y* are scalars or vectors, return the result of their tanimoto distance.

If *X* or *Y* is a matrix, return a vector that is the result of the tanimoto distance between elements in each column. Note that if both *X* and *Y* are indexed matrices or indexed series, return the results of rows with the same label. Rows with different labels will be ignored.

As with all other aggregate functions, null values are ignored in the calculation.

Here is the formula of Tanimoto similarity \(similar\). Tanimoto distance is calculated as 1-similar.

## Examples {#examples}

```
a=[10.5, 11.8, 9]
b=[11.3, 15.1, 8.9]
tanimoto(a,b)
// output: 0.029706

s1=indexedSeries(2020.01.01..2020.01.03, 10.4 11.2 9)
s2=indexedSeries(2020.01.01 2020.01.03 2020.01.04, 23.5 31.2 26)
tanimoto(s1,s2)
// output: 0.5585

m=matrix(23 56 47, 112 94 59)
m1=matrix(11 15 89, 52 41 63)
tanimoto(m,m1)
// output: [0.40490.3242]

m.rename!(2020.01.01..2020.01.03, `A`B)
m.setIndexedMatrix!()
m1.rename!(2020.01.01 2020.01.03 2020.01.04, `A`B)
m1.setIndexedMatrix!()
tanimoto(m,m1)
// output: [0.5494,0.3225]
```

Related function: [rowTanimoto](../r/rowTanimoto.md)

